/*
 * Decompiled with CFR 0.152.
 */
package jef.machine;

import jef.cpuboard.BasicCpuBoard;
import jef.cpuboard.CpuBoard;
import jef.cpuboard.CpuDriver;
import jef.machine.Machine;
import jef.machine.MachineDriver;
import jef.map.InterruptHandler;
import jef.map.WriteHandler;
import jef.sound.SoundEmulation;
import jef.util.Config;
import jef.video.BitMap;

public class BasicMachine
implements Machine {
    public MachineDriver md;
    public CpuDriver[] cd;
    public CpuBoard[] cb;
    public SoundEmulation se;
    protected int slicesPerFrame;
    protected int currentSlice = 0;
    protected boolean soundEnabled = true;
    public boolean nmi_interrupt_enabled = true;
    public boolean interrupt_enabled = true;
    private boolean highScoreSupported;
    private long highScore;
    protected BitMap backBuffer;

    public void init(MachineDriver md) {
        md.mach = this;
        this.md = md;
        if (md.info) {
            return;
        }
        this.cd = md.cpuDriver;
        this.cb = new CpuBoard[this.cd.length];
        this.slicesPerFrame = md.spf;
        int c = 0;
        while (c < this.cd.length) {
            if (this.slicesPerFrame < this.cd[c].ipf) {
                this.slicesPerFrame = this.cd[c].ipf;
            }
            this.cb[c] = this.createCpuBoard(c);
            this.cb[c].init(this.cd[c]);
            this.cd[c].cpu.setTag("CPU #" + Integer.toString(c));
            this.cd[c].cpu.reset();
            ++c;
        }
        if (this.slicesPerFrame == 0) {
            this.slicesPerFrame = 1;
        }
        this.se = new SoundEmulation();
        if (md.soundChips != null) {
            System.out.println("Sound initializing...");
            this.se.init(md.soundChips, Config.SOUND_SAMPLING_FREQ, Config.SOUND_BUFFER_SIZE, md.fps);
        }
        System.out.println("Video initializing...");
        md.ve.init(md);
        if (md.initProms != null) {
            System.out.println("Generating palette...");
            md.initProms.palette_init();
        }
        if (md.vh_start != null) {
            System.out.println("Starting video emulation...");
            md.vh_start.vh_start();
        }
        System.out.println("Video initialized successfully.");
        System.out.println("Machine initializing...");
        md.init.exec();
        System.out.println("Machine initialized successfully.");
        System.out.println(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public void setSound(boolean enable) {
        this.soundEnabled = enable;
        if (this.md.soundChips != null) {
            int c = 0;
            while (c < this.md.soundChips.length) {
                if (this.soundEnabled) {
                    this.md.soundChips[c].enable();
                } else {
                    this.md.soundChips[c].disable();
                }
                ++c;
            }
        }
    }

    public void setHighScoreSupported(boolean b) {
        this.highScoreSupported = b;
    }

    public boolean isHighScoreSupported() {
        return this.highScoreSupported;
    }

    public void setHighScore(long score) {
        if (this.highScoreSupported && score > this.highScore) {
            this.highScore = score;
        }
    }

    public long getHighScore() {
        return this.highScore;
    }

    public void resetHighScore() {
        this.highScore = 0L;
    }

    public void reset(boolean hard) {
        if (!this.highScoreSupported) {
            int c = 0;
            while (c < this.cd.length) {
                this.cd[c].cpu.reset();
                ++c;
            }
        }
    }

    public int getProperty(int property) {
        if (property == 0) {
            return this.md.fps;
        }
        if (property == 3) {
            return this.md.ROT;
        }
        return -1;
    }

    public void keyPress(int keyCode) {
        int i = 0;
        while (i < this.md.input.length) {
            this.md.input[i].keyPress(keyCode);
            ++i;
        }
    }

    public void keyRelease(int keyCode) {
        int i = 0;
        while (i < this.md.input.length) {
            this.md.input[i].keyRelease(keyCode);
            ++i;
        }
    }

    protected void updateInput() {
        int i = 0;
        while (i < this.md.input.length) {
            this.md.input[i].update();
            ++i;
        }
    }

    public int readinputport(int port) {
        return this.md.input[port].read(0);
    }

    public int getCurrentSlice() {
        return this.currentSlice;
    }

    public BitMap refresh(boolean render) {
        boolean rendered = false;
        int curCycle = 0;
        int cpf = this.cd[0].frq / this.md.fps;
        int slice = 0;
        while (slice < this.slicesPerFrame) {
            this.currentSlice = slice;
            int c = 0;
            while (c < this.cd.length) {
                if (!this.cd[c].isAudioCpu || this.cd[c].isAudioCpu && this.soundEnabled) {
                    int slicesPerInterrupt;
                    int cyclesPerFrame = this.cd[c].frq / this.md.fps;
                    int cyclesPerTimeSlice = cyclesPerFrame / this.slicesPerFrame;
                    if (c == 0) {
                        curCycle += cyclesPerTimeSlice;
                    }
                    this.cd[c].cpu.exec(cyclesPerTimeSlice);
                    int interruptsPerFrame = this.cd[c].ipf;
                    if (interruptsPerFrame > 0 && slice % (slicesPerInterrupt = this.slicesPerFrame / interruptsPerFrame) == 0) {
                        this.cb[c].interrupt(this.cd[c].irh.irq(), true);
                    }
                }
                ++c;
            }
            if (!rendered && render && curCycle > this.md.getVideoBlankDuration()) {
                this.backBuffer = this.getDisplay();
                rendered = true;
            }
            ++slice;
        }
        this.se.update();
        this.updateInput();
        return this.backBuffer;
    }

    protected BitMap getDisplay() {
        BitMap p = this.md.vh_screenrefresh.video_update();
        this.md.vh_screenrefresh.video_post_update();
        return p;
    }

    public CpuBoard createCpuBoard(int id) {
        return new BasicCpuBoard();
    }

    public InterruptHandler irq0_line_hold() {
        return new Interrupt_switched();
    }

    public InterruptHandler nmi_interrupt_switched() {
        return new NMI_interrupt_switched();
    }

    public InterruptHandler interrupt_switched() {
        return new Interrupt_switched();
    }

    public WriteHandler nmi_interrupt_enable() {
        return new NMI_interrupt_enable();
    }

    public WriteHandler interrupt_enable() {
        return new Interrupt_enable();
    }

    public InterruptHandler nmi_interrupt() {
        return new NMI_interrupt();
    }

    public InterruptHandler interrupt() {
        return new Interrupt();
    }

    public double getProgress() {
        double cyclesPerFrame = (double)this.md.getCpuDriver()[0].frq / (double)this.md.fps;
        double cyclesPerSlice = cyclesPerFrame / (double)this.slicesPerFrame;
        double curSliceCyclesLeft = this.cb[0].getCpu().getCyclesLeft();
        double cyclesPerFrameLeft = cyclesPerFrame - ((double)(this.currentSlice + 1) * cyclesPerSlice - curSliceCyclesLeft);
        return 1.0 - cyclesPerFrameLeft / cyclesPerFrame;
    }

    public class NMI_interrupt_switched
    implements InterruptHandler {
        public int irq() {
            return BasicMachine.this.nmi_interrupt_enabled ? 1 : -1;
        }
    }

    public class Interrupt_switched
    implements InterruptHandler {
        public int irq() {
            return BasicMachine.this.interrupt_enabled ? 0 : -1;
        }
    }

    public class NMI_interrupt_enable
    implements WriteHandler {
        public void write(int address, int value) {
            BasicMachine.this.nmi_interrupt_enabled = value != 0;
        }
    }

    public class Interrupt_enable
    implements WriteHandler {
        public void write(int address, int value) {
            BasicMachine.this.interrupt_enabled = value != 0;
        }
    }

    public class NMI_interrupt
    implements InterruptHandler {
        public int irq() {
            return 1;
        }
    }

    public class Interrupt
    implements InterruptHandler {
        public int irq() {
            return 0;
        }
    }
}

